/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.block.inv.BotanyPotMenu;
import net.darkhax.botanypots.block.inv.SlotCropSeed;
import net.darkhax.botanypots.block.inv.SlotSoil;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_757;

public class BotanyPotScreen
extends class_465<BotanyPotMenu> {
    private static final NumberFormat MULTIPLIER_FORMAT = new DecimalFormat("##.##");
    private static final class_2561 NEW_LINE = class_2561.method_43470((String)"");
    private static final class_2561 TOOLTIP_INVALID_SOIL = class_2561.method_43471((String)"tooltip.botanypots.invalid_soil").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_INVALID_CROP = class_2561.method_43471((String)"tooltip.botanypots.invalid_seed").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_INCORRECT_SOIL = class_2561.method_43471((String)"tooltip.botanypots.incorrect_soil").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_INCORRECT_SEED = class_2561.method_43471((String)"tooltip.botanypots.incorrect_seed").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_MISSING_SOIL = class_2561.method_43471((String)"tooltip.botanypots.missing_soil").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_MISSING_SEED = class_2561.method_43471((String)"tooltip.botanypots.missing_seed").method_27692(class_124.field_1061);
    private static final class_2561 TOOLTIP_SOIL_ITEM = class_2561.method_43471((String)"tooltip.botanypots.soil_item").method_27692(class_124.field_1060);
    private static final class_2561 TOOLTIP_SEED_ITEM = class_2561.method_43471((String)"tooltip.botanypots.seed_item").method_27692(class_124.field_1060);
    private static final class_2960 RECIPE_BUTTON_LOCATION = new class_2960("textures/gui/recipe_button.png");
    private final class_2960 backgroundTexture;

    public BotanyPotScreen(BotanyPotMenu menu, class_1661 playerInv, class_2561 name) {
        super((class_1703)menu, playerInv, name);
        this.backgroundTexture = new class_2960("botanypots", "textures/gui/container/" + (menu.isHopper() ? "hopper_botany_pot_gui.png" : "botany_pot_gui.png"));
    }

    public void method_25426() {
        super.method_25426();
        int recipeOffset = this.field_2776 + (((BotanyPotMenu)this.field_2797).isHopper() ? 13 : 33);
        this.method_37063((class_364)new class_344(recipeOffset, this.field_22790 / 2 - 49, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, btn -> {}));
    }

    protected void method_2389(class_4587 poseStack, float v, int i, int i1) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.backgroundTexture);
        this.method_25302(poseStack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float tickDelta) {
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, tickDelta);
        this.method_2380(poseStack, mouseX, mouseY);
    }

    public List<class_2561> method_25408(class_1799 stack) {
        List tooltips = super.method_25408(stack);
        if (this.field_22787 != null) {
            boolean isAdvanced = this.field_22787.field_1690.field_1827;
            class_746 player = this.field_22787.field_1724;
            BlockEntityBotanyPot pot = ((BotanyPotMenu)this.field_2797).getPotInventory().getPotEntity();
            class_1937 level = pot.method_10997();
            class_2338 pos = pot.method_11016();
            class_1735 class_17352 = this.field_2787;
            if (class_17352 instanceof SlotSoil) {
                SlotSoil soilSlot = (SlotSoil)class_17352;
                if (!pot.isValidSoil(stack)) {
                    tooltips.add(TOOLTIP_INVALID_SOIL);
                } else {
                    soil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (soil != null) {
                        if (pot.getCrop() == null) {
                            tooltips.add(TOOLTIP_MISSING_SEED);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, (Soil)((Object)soil), pot.getCrop())) {
                            tooltips.add(TOOLTIP_INCORRECT_SOIL);
                        } else {
                            float growthModifier = soil.getGrowthModifier(level, pos, pot, pot.getCrop());
                            class_5250 multiplier = class_2561.method_43470((String)MULTIPLIER_FORMAT.format(growthModifier)).method_27692(growthModifier > 1.0f ? class_124.field_1060 : (growthModifier < 1.0f ? class_124.field_1061 : class_124.field_1080));
                            tooltips.add(class_2561.method_43469((String)"tooltip.botanypots.soil_modifier", (Object[])new Object[]{multiplier}).method_27692(class_124.field_1080));
                        }
                    }
                }
            } else {
                soil = this.field_2787;
                if (soil instanceof SlotCropSeed) {
                    Crop crop;
                    SlotCropSeed seedSlot = (SlotCropSeed)((Object)soil);
                    if (!pot.isValidSeed(stack)) {
                        tooltips.add(TOOLTIP_INVALID_CROP);
                    }
                    if ((crop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        if (pot.getSoil() == null) {
                            tooltips.add(TOOLTIP_MISSING_SOIL);
                        } else if (!BotanyPotHelper.canCropGrow(level, pos, pot, pot.getSoil(), crop)) {
                            tooltips.add(TOOLTIP_INCORRECT_SEED);
                        }
                    }
                } else {
                    Crop hoveredCrop;
                    Soil hoverSoil = BotanyPotHelper.findSoil(level, pos, pot, stack);
                    if (hoverSoil != null) {
                        tooltips.add(TOOLTIP_SOIL_ITEM);
                        if (isAdvanced) {
                            tooltips.add(class_2561.method_43469((String)"tooltip.botanypots.soil_id", (Object[])new Object[]{hoverSoil.method_8114().toString()}).method_27692(class_124.field_1080));
                        }
                    }
                    if ((hoveredCrop = BotanyPotHelper.findCrop(level, pos, pot, stack)) != null) {
                        tooltips.add(TOOLTIP_SEED_ITEM);
                        if (isAdvanced) {
                            tooltips.add(class_2561.method_43469((String)"tooltip.botanypots.crop_id", (Object[])new Object[]{hoveredCrop.method_8114().toString()}).method_27692(class_124.field_1080));
                        }
                    }
                }
            }
        }
        return tooltips;
    }
}

